STEC     EQU #F7FF
EKRAN    EQU #E800
CURSOR   EQU #E000
WRK      EQU #F750
RWRK     EQU WRK+#1F
ABUF     EQU WRK+#15
BUF      EQU WRK+#70
WORK     EQU WRK+#2B
REGP     EQU #E77C
SREG     EQU WRK+#AD
PORT0    EQU 0
PORT1    EQU 1
PORT2    EQU 2
PORT3    EQU 3
PORT4    EQU 4
PORT5    EQU 5
PORT6    EQU 6
PORT7    EQU 7
CR       EQU #0D
LF       EQU #0A

         ORG #F800


         JP START
         JP CI
         JP MI
         JP CO
         JP MO
         JP CO
         JP STAT
         JP D16
         JP DISSO


START    LD HL,BUF
         LD (ABUF),HL
         LD SP,STEC
         LD A,#1F
         CALL DIS
BEGIN    LD A,#8B
         OUT (PORT4),A
         LD SP,STEC
         LD HL,SOOB
         CALL DISSO
         CALL RADR
         LD HL,BEGIN
         PUSH HL
BEG1     LD HL,WORK
         LD B,(HL)
         LD HL,TBL
LOOP     LD A,(HL)
         AND A
         JP Z,ERROR
         CP B
         JP Z,JOB
         INC HL
         INC HL
         INC HL
         JP LOOP

JOB      INC HL
         LD SP,HL
         POP HL
         LD SP,SREG
         JP (HL)

RADR     LD HL,WORK
RAD      CALL CI
         CP 8
         JP Z,DELE
         CALL NZ,DIS
         LD (HL),A
         CP CR
         JP Z,BKK
         LD A,#9A
         CP L
         INC HL
         JP NZ,RAD

ERROR    LD A,#3F
         CALL DIS
         JP BEGIN


BKK      LD (HL),CR
         RET


DELE     CALL DELET
         JP RAD

DELET    LD A,#7B
         CP L
         RET Z
         LD A,8
         CALL DIS
         DEC HL
         RET

PV       CALL PROB
         LD HL,WORK
PVV0     LD B,0
PVV      CALL CI
         CP 8
         JP Z,OGR
         CALL NZ,DIS
         LD (HL),A
         CP " "
         JP Z,SPACE
         CP CR
         JP Z,BK
         LD B,#FF
         LD A,#9A
         CP L
         JP Z,ERROR
         INC HL
         JP PVV

SPACE    LD (HL),CR
         LD A,B
         RLA
         LD DE,WORK
         LD B,0
         RET

OGR      CALL DELET
         JP Z,PVV0
         JP PVV

BK       INC SP
         INC SP
         RET

DISSOOB  LD HL,CRLF
DISSO    LD A,(HL)
         AND A
         RET Z
         CALL DIS
         INC HL
         JP DISSO

ADRES    LD HL,WRK+1
         LD B,6
         XOR A
LIP      LD (HL),A
         DEC B
         JP NZ,LIP
         LD DE,RWRK+#0D
         CALL OBADR
         LD (WRK+1),HL
         LD (WRK+3),HL
         RET C
         CALL OBADR
         LD (WRK+3),HL
         PUSH AF
         PUSH DE
         EX DE,HL
         LD HL,(WRK+1)
         EX DE,HL
         CALL HILO1
         JP C,ERROR
         POP DE
         POP AF
         RET C
         CALL OBADR
         LD (WRK+5),HL
         RET C
         JP ERROR

OBADR    LD HL,0
FSP      LD A,(DE)
         INC DE
         CP CR
         JP Z,FBK
         CP ","
         RET Z
         CP " "
         JP Z,FSP
         SUB "0"
         JP M,ERROR
         CP LF
         JP M,FLF
         CP #11
         JP M,ERROR
         CP #17
         JP P,ERROR
         SUB 7
FLF      LD C,A
         ADD HL,HL
         ADD HL,HL
         ADD HL,HL
         ADD HL,HL
         JP C,ERROR
         ADD HL,BC
         JP FSP
FBK      SCF
         RET

AD16     LD HL,(WRK+1)
         LD A,(HL)
D16      LD B,A
         LD A,B
         RRCA
         RRCA
         RRCA
         RRCA
         CALL CD16
         LD A,B
CD16     AND #0F
         CP #0A
         JP M,MD16
         ADD A,7
MD16     ADD A,#30
         JP DIS
MD161    CALL DISSOOB
         LD HL,WRK+2
ADR16    LD A,(HL)
         CALL D16
         DEC HL
         LD A,(HL)
         CALL D16
PROB     LD A," "
         JP DIS

HILO     PUSH DE
         LD HL,(WRK+1)
         EX DE,HL
         LD HL,(WRK+3)
         CALL HILO1
         POP DE
         JP Z,BK
         LD HL,WRK+1
HIL      INC (HL)
         RET NZ
         INC HL
         INC (HL)
         RET

HILO1    LD A,H
         CP D
         RET NZ
         LD A,L
         CP E
         RET

XREG     LD HL,RWRK+#0D
         LD A,(HL)
         CP CR
         JP Z,MBK
         CP "S"
         JP Z,S
         LD DE,DIR
         CALL ADRS
         LD HL,ABUF
         INC DE
         LD A,(DE)
         LD L,A
         PUSH HL
         CALL PROB
         LD A,(HL)
         CALL D16
         CALL PV
         JP NC,BEGIN
         CALL OBADR
         LD A,L
         POP HL
         LD (HL),A
         RET

S        CALL PROB
         LD HL,ABUF+1
         CALL ADR16
         CALL PV
         JP NC,BEGIN
         CALL OBADR
         LD (ABUF),HL
         RET

ADRS     LD A,(DE)
         AND A
         JP Z,ERROR
         CP (HL)
         RET Z
         INC DE
         INC DE
         JP ADRS

MBK      LD DE,DIR
         LD B,8
         CALL DISSOOB
MB1      LD A,(DE)
         LD C,A
         INC DE
         PUSH BC
         CALL RAZD
         LD A,(DE)
         LD HL,ABUF
         LD L,A
         LD A,(HL)
         CALL D16
         POP BC
         INC DE
         DEC B
         JP NZ,MB1
         LD A,(DE)
         LD C,A
         CALL RAZD
         LD HL,(ABUF)
         LD (WRK+1),HL
         CALL ADR16-3
         LD C,"O"
         CALL RAZD
         LD HL,WRK+#20
         CALL ADR16
         JP DISSOOB

RAZD     CALL PROB
         LD A,C
         CALL DIS
         LD A,"-"
         JP DIS

DIR      DEFM "A"
         DEFB #68
         DEFM "B"
         DEFB #6A
         DEFM "C"
         DEFB #69
         DEFM "D"
         DEFB #6C
         DEFM "E"
         DEFB #6B
         DEFM "F"
         DEFB #67
         DEFM "H"
         DEFB #6E
         DEFM "L"
         DEFB #6D
         DEFM "S"
         DEFB #65
         DEFB 0

SBS      DEFB LF
         DEFM "START-"
         DEFB 0
SBD      DEFB LF
         DEFM "DIR. -"
         DEFB 0

BASTR    CALL ADRES
         CALL OST
         LD HL,(WRK+1)
         LD A,(HL)
         LD (HL),#FF
         LD (RWRK+3),HL
         LD (RWRK+5),A
         RET

OST      LD A,#C3
         LD (#0038),A
         LD HL,WOST
         LD (#0039),HL
         RET

WOST     LD (RWRK-2),HL
         PUSH AF
         LD HL,4
         ADD HL,SP
         LD (ABUF),HL
         POP AF
         EX (SP),HL
         DEC HL
         EX (SP),HL
         LD SP,RWRK-2
         PUSH DE
         PUSH BC
         PUSH AF
         LD SP,STEC
         LD HL,(ABUF)
         DEC HL
         LD D,(HL)
         DEC HL
         LD E,(HL)
         LD L,E
         LD H,D
         LD (RWRK),HL
         LD HL,(RWRK+3)
         CALL HILO1
         JP Z,WOS
         LD HL,(RWRK+6)
         CALL HILO1
         JP Z,POT
         LD HL,(RWRK+#09)
         CALL HILO1
         JP Z,POT1
         JP ERROR
WOS      LD A,(RWRK+5)
         LD (HL),A
         LD HL,#FFFF
         LD (RWRK+3),HL
         JP BEGIN

GO       CALL ADRES
         LD A,(RWRK+#0D)
         CP CR
         JP NZ,GO1
         LD HL,(RWRK)
         LD (WRK+1),HL
GO1      LD A,#C3
         LD (WRK),A
         LD SP,ABUF
         POP HL
         POP AF
         POP BC
         POP DE
         LD SP,HL
         LD HL,(RWRK-2)
         JP WRK

POTL     CALL ADRES
         CALL OST
         LD HL,(WRK+1)
         LD (RWRK+6),HL
         LD A,(HL)
         LD (HL),#FF
         LD (RWRK+8),A
         LD HL,(WRK+3)
         LD (RWRK+9),HL
         LD A,(HL)
         LD (HL),#FF
         LD (RWRK+#0B),A
         LD A,(WRK+5)
         LD (RWRK+2),A
         LD HL,SBS
         CALL DISSO
         LD HL,RWRK+#0D
         CALL RAD
         CALL ADRES
         LD HL,SBD
         CALL DISSO
         CALL RADR
         JP GO1

POT      LD A,(RWRK+8)
         LD (HL),A
         LD HL,(RWRK+#09)
         LD A,#FF
         CP (HL)
         JP Z,POT0
         LD B,(HL)
         LD (HL),A
         LD A,B
         LD (RWRK+#0B),A
POT0     CALL MBK
         CALL BEG1
         LD HL,(RWRK)
         LD (WRK+1),HL
         JP GO1

POT1     LD A,(RWRK+#0B)
         LD (HL),A
         LD HL,(RWRK+6)
         LD A,#FF
         CP (HL)
         JP Z,POT0
         LD B,(HL)
         LD (HL),A
         LD A,B
         LD (RWRK+8),A
         LD HL,RWRK+2
         DEC (HL)
         JP NZ,POT0
         LD A,(RWRK+8)
         LD HL,(RWRK+6)
         LD (HL),A
         JP BEGIN

DISPL    CALL ADRES
         CALL DISSOOB
DIPL1    CALL MD161
IPL2     CALL PROB
         CALL AD16
         CALL HILO
         LD A,(WRK+1)
         AND #0F
         JP Z,DIPL1
         JP IPL2

CREF     CALL ADRES
         LD HL,(WRK+5)
         EX DE,HL
CRE      LD HL,(WRK+1)
         LD A,(DE)
         CP (HL)
         JP Z,CRE1
         CALL MD161
         CALL PROB
         CALL AD16
         CALL PROB
         LD A,(DE)
         CALL D16
CRE1     INC DE
         CALL HILO
         JP CRE

FMEM     CALL ADRES
         LD A,(WRK+5)
         LD B,A
FM       LD HL,(WRK+1)
         LD (HL),B
         CALL HILO
         JP FM

SBAIT    CALL ADRES
         LD C,L
SB       LD HL,(WRK+1)
         LD A,C
         CP (HL)
         CALL Z,MD161
         CALL HILO
         JP SB

TMEM     CALL ADRES
         LD HL,(WRK+5)
         EX DE,HL
TM       LD HL,(WRK+1)
         LD A,(HL)
         LD (DE),A
         INC DE
         CALL HILO
         JP TM
;
MEMOR    CALL ADRES
MEM      CALL PROB
         CALL AD16
         CALL PV
         JP NC,MEM1
         CALL OBADR
         LD A,L
         LD HL,(WRK+1)
         LD (HL),A
MEM1     LD HL,WRK+1
         CALL HIL
         CALL MD161
         JP MEM

JOBS     CALL ADRES
         LD HL,(WRK+1)
         JP (HL)

MA       CALL DISSOOB
         LD A,(RWRK+#0D)
         CALL D16
         JP DISSOOB

KLB      CALL CI
         CP 1
         JP Z,BEGIN
         CALL DIS
         JP KLB

QMEM     CALL ADRES
QM       LD HL,(WRK+1)
         LD C,(HL)
         LD A,#55
         LD (HL),A
         CP (HL)
         CALL NZ,QM1
         LD A,#AA
         LD (HL),A
         CP (HL)
         CALL NZ,QM1
         LD (HL),C
         CALL HILO
         JP QM

QM1      PUSH AF
         CALL MD161
         CALL PROB
         CALL AD16
         CALL PROB
         POP AF
         CALL D16
         RET

LMEM     CALL ADRES
         CALL DISSOOB
LM0      CALL MD161
LM       CALL PROB
         LD HL,(WRK+1)
         LD A,(HL)
         CP #20
         JP C,LM1
         CP #80
         JP NC,LM1
         JP LM2

LM1      LD A,"."
LM2      CALL DIS
         CALL HILO
         LD A,(WRK+1)
         AND #0F
         JP Z,LM0
         JP LM

HEX      LD HL,WRK+1
         LD B,6
         XOR A
HE1      LD (HL),A
         DEC B
         JP NZ,HE1
         LD DE,RWRK+#0D
         CALL OBADR
         LD (WRK+1),HL
         CALL OBADR
         LD (WRK+3),HL
         CALL DISSOOB
         LD HL,(WRK+1)
         LD (WRK+5),HL
         EX DE,HL
         LD HL,(WRK+3)
         ADD HL,DE
         LD (WRK+1),HL
         CALL MD161+3
         LD HL,(WRK+3)
         EX DE,HL
         LD HL,(WRK+5)
         LD A,E
         CPL
         LD E,A
         LD A,D
         CPL
         LD D,A
         INC DE
         ADD HL,DE
         LD (WRK+1),HL
         CALL MD161+3
         JP DISSOOB

INPUT     LD A,#FF
          CALL MI
          LD (WRK+2),A
          LD (WRK+#0F),A
          LD A,8
          CALL MI
          LD (WRK+1),A
          LD (WRK+#0E),A
          LD A,8
          CALL MI
          LD (WRK+4),A
          LD (WRK+#11),A
          LD A,8
          CALL MI
          LD (WRK+3),A
          LD (WRK+#10),A
          LD A,8
          LD HL,IN3
          PUSH HL
INP1      LD HL,(WRK+1)
          CALL MI
          LD (HL),A
          CALL HILO
          LD A,8
          JP INP1

IN3       LD HL,WRK+#0F
          CALL ADR16
          LD HL,WRK+#11
          CALL ADR16
          JP DISSOOB

OUTPUT    CALL ADRES
          XOR A
          LD B,0
OU1       CALL MO
          DEC B
          JP NZ,OU1
          LD A,#E6
          CALL MO
          LD A,(WRK+2)
          CALL MO
          LD A,(WRK+1)
          CALL MO
          LD A,(WRK+4)
          CALL MO
          LD A,(WRK+3)
          CALL MO
OU2       LD HL,(WRK+1)
          LD A,(HL)
          CALL MO
          CALL HILO
          JP OU2

VERIFI    LD A,#FF
          CALL MI
          LD (WRK+2),A
          LD A,8
          CALL MI
          LD (WRK+1),A
          LD A,8
          CALL MI
          LD (WRK+4),A
          LD A,8
          CALL MI
          LD (WRK+3),A
VER0      LD A,8
          CALL MI
          LD HL,(WRK+1)
          CP (HL)
          JP Z,VER1
          PUSH AF
          CALL MD161
          CALL PROB
          CALL AD16
          CALL PROB
          POP AF
          CALL D16
VER1      CALL HILO
          JP VER0

MI        PUSH BC
          PUSH DE
          LD C,0
          LD D,A
          IN A,(PORT1)
          LD E,A
MI0       LD A,C
          AND #7F
          RLCA
          LD C,A
MI1       IN A,(PORT1)
          CP E
          JP Z,MI1
          AND 1
          OR C
          LD C,A
          CALL DELAY7
          IN A,(PORT1)
          LD E,A
          LD A,D
          OR A
          JP P,MI5
          LD A,C
          CP #E6
          JP NZ,MI4
          XOR A
          LD (WRK+7),A
          JP MI3
MI4       CP #19
          JP NZ,MI0
          LD A,#FF
          LD (WRK+7),A
MI3       LD D,9
MI5       DEC D
          JP NZ,MI0
          LD A,(WRK+7)
          XOR C
          POP DE
          POP BC
          RET

DELAY7    PUSH AF
          LD A,(WRK+#0C)
DELY33    LD B,A
          POP AF
DELY      DEC B
          JP NZ,DELY
          RET

MO        PUSH BC
          PUSH DE
          PUSH AF
          LD D,A
          LD C,8
MO0       LD A,D
          RLCA
          LD D,A
          LD A,1
          XOR D
          OUT (PORT1),A
          CALL DELY5
          LD A,0
          XOR D
          OUT (PORT1),A
          CALL DELY5
          DEC C
          JP NZ,MO0
          POP AF
          POP DE
          POP BC
          RET

DELY5     PUSH AF
          LD A,(WRK+#0D)
          JP DELY33


TBL       DEFM "M"
          DEFW MEMOR
          DEFM "C"
          DEFW CREF
          DEFM "D"
          DEFW DISPL
          DEFM "B"
          DEFW BASTR
          DEFM "G"
          DEFW GO
          DEFM "P"
          DEFW POTL
          DEFM "X"
          DEFW XREG
          DEFM "F"
          DEFW FMEM
          DEFM "S"
          DEFW SBAIT
          DEFM "T"
          DEFW TMEM
          DEFM "I"
          DEFW INPUT
          DEFM "O"
          DEFW OUTPUT
          DEFM "V"
          DEFW VERIFI
          DEFM "J"
          DEFW JOBS
          DEFM "A"
          DEFW MA
          DEFM "K"
          DEFW KLB
          DEFM "Q"
          DEFW QMEM
          DEFM "L"
          DEFW LMEM
          DEFM "H"
          DEFW HEX
          DEFB 0


SOOB      DEFB LF
          DEFM "*MikrO/80* MONITOR"
          DEFB LF,#3E,0
CRLF      DEFB LF,0


DIS       PUSH HL
          PUSH BC
          PUSH DE
          PUSH AF
          LD C,A
          JP DI1


CO        PUSH HL
          PUSH BC
          PUSH DE
          PUSH AF
DI1       LD HL,(WRK+#0A)
          LD DE,#F801
          ADD HL,DE
          LD (HL),0
          LD HL,(WRK+#0A)
          LD A,C  
          CP #1F
          JP Z,CTR
          CP 8
          JP Z,LEV
          CP #18
          JP Z,PRAV
          CP #19
          JP Z,VERX
          CP #1A
          JP Z,VNIZ
          CP LF
          JP Z,DLF
          CP #0C
          JP Z,HOME
          LD A,H
          CP #F0
          JP NZ,NEP
          CALL STAT
          OR A
          JP Z,ECT
          CALL CI
ECT       CALL CLEAR
          LD HL,EKRAN
NEP       LD (HL),C
          INC HL
OKON      LD (WRK+#0A),HL
          LD DE,#F801
          ADD HL,DE
          LD (HL),#80
          POP AF
          POP DE
          POP BC
          POP HL
          RET

CTR       CALL CLEAR
HOME      LD HL,EKRAN
          JP OKON

CLEAR     LD HL,EKRAN
          LD DE,CURSOR
CLE1      LD (HL)," "
          INC HL
          LD A,0
          LD (DE),A
          INC DE
          LD A,H
          CP #F0
          RET Z
          JP CLE1
PRAV      INC HL
          LD A,H
          CP #F0
          JP NZ,OKON
          JP Z,HOME
LEV       DEC HL
          LD A,H
          CP #E7
          JP NZ,OKON
          LD HL,#EFFF
          JP OKON
VNIZ      LD DE,#0040
          ADD HL,DE
          LD A,H
          CP #F0
          JP NZ,OKON
          LD H,#E8
          JP OKON
VERX      LD DE,#FFC0
          ADD HL,DE
          LD A,H
          CP #E7
          JP NZ,OKON
          LD DE,#0800
          ADD HL,DE
          JP OKON

DLF       INC HL
          LD A,L
          OR A
          JP Z,DLF1
          CP #40
          JP Z,DLF1
          CP #80
          JP Z,DLF1
          CP #C0
          JP Z,DLF1
          JP DLF

DLF1      LD A,H
          CP #F0
          JP NZ,OKON
          CALL STAT
          OR A
          JP Z,CTR
          CALL CI
          JP CTR

CI        PUSH BC
          PUSH DE
          PUSH HL
CI0       LD B,0
          LD C,#FE
          LD D,8
CI2       LD A,C
          OUT (PORT7),A
          RLCA
          LD C,A
          IN A,(PORT6)
          AND #7F
          CP #7F
          JP NZ,CI1
          LD A,B
          ADD A,7
          LD B,A
          DEC D
          JP NZ,CI2
          JP CI0

CI1       LD (WRK+#14),A
          RRA
          JP NC,CI3
          INC B
          JP CI1+3
CI3       LD A,B
          CP "0"
          JP NC,CI4
          ADD A,"0"
          CP #3C
          JP C,CI5
          CP #40
          JP NC,CI5
          AND #2F
CI5       LD C,A
          JP CI6

CI4       LD HL,TBLK
          SUB #30
          LD C,A
          LD B,0
          ADD HL,BC
          LD A,(HL)
          JP CI7

CI6       IN A,(PORT5)
          AND #07
          CP 7
          JP Z,CI8 
          RRA 
          RRA
          JP NC,CI9
          RRA
          JP NC,CI10
          LD A,C
          OR #20
          JP CI7

CI9       LD A,C
          AND #1F
          JP CI7

CI10      LD A,C
          CP #40
          JP NC,CI7
          CP #30
          JP NC,CI11
          OR #10
          JP CI7

CI11      AND #2F
          JP CI7

CI8       LD A,C
CI7       LD C,A
          CALL CDELY
          LD HL,WRK+#14
CI12      IN A,(PORT6)
          CP (HL)
          JP Z,CI12
          CALL CDELY
          LD A,C
          POP HL
          POP DE
          POP BC
          RET

CDELY     LD DE,#0800
CDE       DEC DE
          LD A,D
          OR E
          RET Z
          JP CDE

TBLK      DEFB #20,#18,#08,#19,#1A,CR,#1F,#0C

STAT      LD A,0
          OUT (PORT7),A
          IN A,(PORT6)
          AND #7F
          CP #7F
          JP NZ,MIMO
          XOR A
          RET
MIMO      LD A,#FF
          RET
