﻿
FILES  EQU 3    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #6000

       JR BEGIN

       DEFW #6000 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5FFF

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU      ;Перенос модуля меню в память
       LD DE,MODADR    ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU   ;Адрес строк меню
       LD DE,OPTIONS   ;Адрес массива для опций меню
       CALL MODADR     ;Вызов меню

       LD A,2         ;Загрузка заставки
       LD DE,#8000
       CALL LOAD

       LD HL,#8000   ;Распаковка заставки
       LD DE,#4000
       CALL DEPACK

       LD A,1        ;Загрузка главного блока
       LD DE,#6300
       CALL LOAD


;Пауза перед запуском игры, чтобы полюбоваться заставкой

;Блок функций доступен из 0-го банка ПЗУ картриджа или 2-го банка ПЗУ Эльф
       LD A,(BNK)   ;Первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A
       CALL FUNC+0  ;Функция 0


       LD A,3       ;Загрузка стартового экрана игры
       LD DE,#C000
       CALL LOAD

       LD A,1
       OUT (#5F),A

       LD HL,#C000   ;Распаковка второй заставки
       LD DE,#4000
       CALL DEPACK

       LD HL,#6300   ;Распаковка основного блока
       LD DE,#6300
       CALL DEPACK


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

;Действия для первой опции - бесконечные жизни
       XOR A
       LD (49596),A
       LD (53774),A


OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,STRT

;Действия для второй опции - бесконечное время
       XOR A
       LD (49560),A

;Старт игры
STRT   JP #EE00


LOAD   LD HL,TABLE
       JP LDBLK



;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 2   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU DEFM 'BESKONE^NAQ \NERGIQ'
        DEFB 0
        DEFM 'OTKL@^ENIE TAJMERA'
        DEFB 0,#FF

       INCLUDE "../../files/vars.asm"