﻿

FILES  EQU 4    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5D00

       JR BEGIN

       DEFW #5D00 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK    DEFB #80 ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5CFF

       LD A,(BNK)      ;0-й банк картриджа
       OUT (#5F),A     ;тут находятся модули и распаковщик


       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU       ;Перенос модуля меню в память
       LD DE,MODADR     ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU    ;Адрес строк меню
       LD DE,OPTIONS    ;Адрес массива для опций меню
       CALL MODADR      ;Вызов меню

       LD A,1          ;Загрузка заставки
       LD DE,#6000
       CALL LOAD

       LD HL,#6000    ;Распаковка заставки
       LD DE,#4000
       CALL DEPACK

       LD A,3          ;Загрузка главного блока игры
       LD DE,#6000
       CALL LOAD

       LD HL,#6000     ;Распаковка главного блока игры
       LD D,H
       LD E,L
       CALL DEPACK

       LD A,4
       LD DE,#FF00
       CALL LOAD



       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция - бесконечные жизни
       OR A
       JR Z,OPT2

        ;Действия для первой опции
       XOR A         ;бесконечные жизни
       LD (58356),A


OPT2   LD A,(IX+1)  ;Вторая опция - бесконечные патроны
       OR A
       JR Z,OPT3

        ;Действия для второй опции
       XOR A         ;Бесконечные патроны
       LD (64075),A

OPT3   LD A,(IX+2)  ;Третья опция - бесконечные бомбы
       OR A
       JR Z,ATTR

       ;Действия для третьей опции
       XOR A        ;Бесконечные бомбы
       LD (64166),A


ATTR
       LD HL,#5800   ;Чистим атрибуты экрана
       LD D,H
       LD E,L
       INC DE
       LD (HL),L
       LD BC,768-1
       LDIR

       LD A,2         ;Загрузка остатка главного блока игры в экран
       LD DE,#4000
       CALL LOAD

       LD A,1         ;Выключаем ПЗУ картиджа
       OUT (#5F),A

       LD HL,STARTER       ;Переносим запускалку в экранную область
       LD DE,#5000
       LD BC,ENDER-STARTER
       LDIR
       JP #5000   ;Переход на запускалку и старт игры


;Запускалка игры
STARTER
       LD HL,#4000
       LD DE,#5B00
       LD BC,#0500
       LDIR
       JP #AB4D
ENDER


LOAD   LD HL,TABLE
       JP LDBLK







;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 3   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM 'BESKONE^NYE VIZNI'
  DEFB 0     ;0-конец строки
  DEFM 'BESKONE^NYE PATRONY'
  DEFB 0
  DEFM 'BESKONE^NYE BOMBY'
  DEFB 0
  DEFB #FF   ;#FF-конец массива строк меню

       INCLUDE "../../files/vars.asm"