﻿;Загрузчик должен иметь длину 256 байт или более!!!


FILES  EQU 1    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #C000

       JR BEGIN

       DEFW #C000 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK   DEFB #80  ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18


;-------------------------------


BEGIN
       LD SP,#BFFF

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR

       LD HL,MENU       ;Перенос модуля меню в память
       LD DE,MODADR     ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU    ;Адрес строк меню
       LD DE,OPTIONS    ;Адрес массива для опций меню
       CALL MODADR      ;Вызов меню

       LD A,1        ;загрузка основного блока игры
       LD DE,#5E00
       LD HL,TABLE
       CALL LDBLK

       LD HL,#5E00   ;распаковка
       LD D,H
       LD E,0
       CALL DEPACK

       LD A,1       ;включаем ПЗУ с BASIC-48
       OUT (#5F),A


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT2

;Действия для первой опции - бесконечные жизни
       XOR A
       LD (31007),A
       LD (31008),A
       LD (31009),A


OPT2   LD A,(IX+1)  ;Вторая опция
       OR A
       JR Z,START

;Действия для второй опции - отключение таймера
       XOR A
       LD (26011),A
       LD (26012),A
       LD (26013),A


;Старт игры
START  JP #B932



;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 2   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM "BESKONE^NYE VIZNI"
  DEFB 0     ;0-конец строки
  DEFM "OTKL@^ENIE TAJMERA"
  DEFB 0
  DEFB #FF   ;#FF-конец массива строк меню

       INCLUDE "../../files/vars.asm"