﻿;Загрузчик должен иметь длину 256 байт или более!!!


FILES  EQU 2    ;Сколько файлов будем подгружать (без учёта загрузчика)
                ;Максимальное количество файлов - 18


       ORG #5F00

       JR BEGIN

       DEFW #5F00 ;адрес компиляции загрузчика - должен совпадать с ORG!!!


;-- В этом блоке ничего не трогать! ---
TABLE
       DEFS 3    ;сюда пишется адрес игры в ПЗУ

BNK   DEFB #80  ;Значение порта для включения первого банка ПЗУ с играми
                ;Может принимать значения #80 (для работы игры с картриджа),
                ;либо #02 (для загрузки игры со встроенного ПЗУ Эльф).
                ;Этот байт меняется внешним сборщиком образов ПЗУ

;Структура таблицы
;       DEFS 3    ;смещение файла относительно начала игры
;       DEFW 0    ;длина файла

;       DEFB #FF  ;конец таблицы

       DEFS FILES*5+5+1   ;Резервируем место для таблицы файлов
                          ;Примерное количество файлов - не более 18

;-------------------------------


BEGIN
       LD SP,#5EFF

       LD A,(BNK)      ;первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A     ;тут находятся модули и распаковщик

       LD HL,HRUST     ;перенос распаковщика в память
       LD DE,DEPACK    ;#5B00
       LD BC,LENDEP
       LDIR


       LD HL,MENU       ;Перенос модуля меню в память
       LD DE,MODADR     ;#7000
       LD BC,LENMENU
       LDIR
       LD HL,STRMENU    ;Адрес строк меню
       LD DE,OPTIONS    ;Адрес массива для опций меню
       CALL MODADR      ;Вызов меню

       LD A,1       ;Заставка
       LD DE,#8000
       LD HL,TABLE
       CALL LDBLK

       LD HL,#8000
       LD DE,#4000
       CALL DEPACK

       LD A,2        ;Основной блок
       LD DE,#61A2
       LD HL,TABLE
       CALL LDBLK

       LD A,1        ;Включаем ПЗУ с Basic-48
       OUT (#5F),A

       LD HL,#61A2
       LD D,H
       LD E,L
       CALL DEPACK


;Пауза перед запуском игры, чтобы полюбоваться заставкой

;Блок функций доступен из 0-го банка ПЗУ картриджа или 2-го банка ПЗУ Эльф
       LD A,(BNK)   ;Первый банк картриджа / прошивки ПЗУ
       OUT (#5F),A
       CALL FUNC+0  ;Функция 0

       LD A,1       ;После паузы включаем ПЗУ с BASIC-48
       OUT (#5F),A


       LD IX,OPTIONS ;Адрес опций меню
       LD A,(IX+0)   ;Первая опция
       OR A
       JR Z,OPT4

;Действия для первой опции

       XOR A          ;Бесконечные жизни
       LD (#C340),A

OPT4

;Старт игры
       JP #61A2



;----- ПАРАМЕТРЫ ДЛЯ МЕНЮ ЧИТОВ -----
OPTIONS DEFS 1   ;Массив для опций меню с читами
                 ;Число после DEFS - количество опций в меню с читами

;Массив строк опций меню. Конец строки - 0, конец массива - #FF
STRMENU
  DEFM "BESKONE^NYE VIZNI"
  DEFB 0     ;0-конец строки
;  следующая строка, если надо и т.п.
  DEFB #FF   ;#FF-конец массива строк меню

       INCLUDE "../../files/vars.asm"