﻿# Сборщик игр для приставки "Эльф" из отдельных файлов
# Alf TV GAME builder
# (C) Prusak, https://zxbyte.ru

 
import sys
import re

opisLen = 0x02F4 # Длина описания игры (#02F4 байт)
maxFiles = 18 # Максимальное количество файлов, из которых может состоять игра *.alf


#----------
# Функции


# заполнение массива massive байтом num, длина заполнения - len
def fillByte (massive, len, num):
	i = 0
	while i < len:
		massive[i] = num
		i += 1


# перенос данных (len) из одного массива (massive1) c адресом addr1 во второй (massive2) по адресу addr2
def LDIR (massive1, addr1, massive2, addr2, len):
	i = 0
	while i < len:
		massive2[addr2] = massive1[addr1]
		i += 1
		addr1 += 1
		addr2 += 1


# Запись числа (numb) в 2 или 3 байтовой форме (len) в массив (massive) по адресу (addr)
def writeNum (numb, len, massive, addr):
	if len == 2:
		stByte = numb // 256
		mlByte = numb - stByte * 256
		massive[addr] = mlByte
		massive[addr+1] = stByte
	if len == 3:
		sstByte = numb // 65536
		numb1 = numb - sstByte * 65536
		stByte = numb1 // 256
		mlByte = numb1 - stByte * 256
		massive[addr] = mlByte
		massive[addr+1] = stByte
		massive[addr+2] = sstByte
	if ((len != 3) and (len != 2)):
		print ("ERROR: writeNum input parameter length invalid")


# Чтение числа 1,2,3 байта из массива по адресу addr
def readNum (massive, addr, len):
	if len == 1:
		num = massive[addr]
	if len == 2:
		num = massive[addr] + 256 * massive[addr+1]
	if len == 3:
		num = massive[addr] + 256 * massive[addr+1] + 65536 * massive[addr+2]
	if ((len != 1) and (len != 2) and (len != 3)):
		print ("ERROR: readNum input parameter length invalid")

	return num




# Подсчёт контрольной суммы массива данных. Формат контрольной суммы - как в iS-DOS
def checkSum (massive):
	summa = 0
	i = 0
	while i< len (massive): # сумма всех байтов числа в 16-битном размере
		summa += massive[i]
		if summa > 65535: # приводим сумму к 16-битному значению при переполнении
			summa -= 65536
		i += 1
	return 65536 - summa # 0 - сумма всех байтов = контрольная сумма


# преобразование числа в hex вида #00000, len - формат длины выводимого числа (2, 4 или 6 символов)
def decToHex (arg,len):
	if len == 2:
		return "#" + f"{format (arg,'X'):0>2}"
	if len == 4:
		return "#" + f"{format (arg,'X'):0>4}"
	if len == 6:
		return "#" + f"{format (arg,'X'):0>6}"
	else:
		return "#" + format (arg,'X')


# Открывает файл с именем fileName и возвращает его содержимое в виде списка.
def readFile (fileName, folder):
	if folder != '':	# Если задана папка, то добавляем к ней символ "/"
		folder += "/"

	statusXpos = 15 # X координата для печати статуса проверки. Чтобы статусы были выровнены по одной линии
	if len(fileName) < statusXpos:
		probels = statusXpos - len(fileName)
	else: # но если координата "наползает" на имя файла, игнорируем её
		probels = 1
		
	try:
		print (fileName, end='')
		#допечатываем пробелы после имени файла
		i = 0
		while i < probels:
			print (" ", end='')
			i += 1

		file = open(folder + fileName)
	except IOError as e:
		print('ERROR / No file')
		sys.exit(1)
	else:
# считываем входной файл в список fileMassive
		with open(folder + fileName, "rb") as file:
			fileMassive = file.read()
		print ("checksum = ", end='')
		print (decToHex (checkSum(fileMassive),4)) # Конвертация числа в удобный hex вид #xxxxxxx
		return fileMassive






#---------------------
# Начало программы

print ("\n-----------------------")
print ("ALF games image builder b20250808 (C)Prusak (https://zxbyte.ru)")


# Обрезаем переданные в программу аргументы (первым всегда является путь к исполняемому файлу программы)
args = sys.argv[1:]

# Если вызов программы без аргументов, выходим с ошибкой
if len(args) < 1:
	print ('Invalid command line syntax')
	sys.exit(1)

# Парсим аргументы на нужные типы (входной файл, выходной файл)
i = 0
outputFilePos = ''
inputFilePos = ''
while i < len(args):
	# Проверка на первый указанный файл
	if (outputFilePos == ""):
		outputFilePos = i
	else:
		inputFilePos = i
	i += 1

print ("\n")

# ------------------------------
# Проверка количества аргументов и вывод сообщения об ошибке, если чего-то не хватает
print ("Processing command line arguments... ", end='')
if ((outputFilePos == '') or (inputFilePos == '')):
	print ("ERROR! Not enough arguments")
	sys.exit(1)
else:
	print ("OK")






# --------------------------------
# Создаём выходной файл. Он пока пустой.
outFile = open (args[outputFilePos], "wb")


#Создаём массив данных для выходного файла.
outFileMassive = bytearray (0)



# Открываем список входящих в в игру файлов.
try:
		Inpfile = open(args[inputFilePos])
except IOError as e:
		print ("Input file ", end='')
		print (args[inputFilePos], end='')
		print(' - read error or file not exist!')
		sys.exit(1)

inpFileContents = Inpfile.readlines() # Считываем весь файл в массив строк


print ("Processing file \"", end='')
print (args[inputFilePos], end='')
print ("\" ...")



# Главный цикл. Перебираем файлы игры

inpFileLine = 0 # Счётчик строк во входном файле
inpFileCount = 0 # Счётчик обработанных файлов (должно быть минимум 3 файла - описание, загрузчик и хотя бы один блок игры)
outFileAddr = 0 # Счётчик адреса в выходном файле
while inpFileLine < len (inpFileContents): # Перебираем строки файла
		if inpFileContents[inpFileLine][0] != '#': # Строки с комментариями пропускаем
			if ord(inpFileContents[inpFileLine][0]) != 0x0A: # Переносы строк пропускаем
				# открываем один из файлов игры
				games_data = bytearray(0)
				inpFileName = re.sub(r'[^a-zA-Z0-9\\._;#$@ \-]', '', inpFileContents[inpFileLine]) # Оставляем для имени файла только разрешённые символы
				games_data1 = readFile (inpFileName,'') # Открываем файл
				outFileMassive += games_data1 # Массив с данными файла

				# Если обрабатываем загрузчик
				if inpFileCount == 1:
					outFileCatAddr = outFileAddr + 8 # outFileAddr указывает на начало загрузчика. 8 - смещение в загрузчике, где располагается начало внутреннего каталога файлов.

					# В конец загрузчика добавляем 3 байта с кодом "JP начало загрузчика" (C3 xxxx, где xxxx - адрес компиляции загрузчика).
					# Надо для того, чтобы запустить загрузчик после его выбора в меню приставки, при этом грузится тело загрузчика и выполняется переход на код, расположенный за концом загрузчика (это особенность запуска игр из меню приставки)
					JP_data = bytearray(b'   ')
					JP_data[0] = 0xC3
					JP_data[1] = outFileMassive[outFileAddr+2]
					JP_data[2] = outFileMassive[outFileAddr+3]
					outFileMassive += JP_data					

				# Обрабатываем загрузчик и непосредственные файлы игры (исключаем описание игры)
				# Заносим данные о файле во внутренний каталог
				if inpFileCount > 0:
					writeNum (outFileAddr, 3, outFileMassive, outFileCatAddr) # Заносим смещение для текущего файла
					writeNum (len(games_data1), 2, outFileMassive, outFileCatAddr+3) # Заносим длину файла

					outFileCatAddr += 5 # Адрес следующего файла в каталоге
				
				outFileAddr += len(games_data1) # Увеличиваем адрес в выходном файле для следующего файла
				if inpFileCount == 1: # Если обрабатывали загрузчик, то к нему добавляем ещё 3 байта
					outFileAddr += 3
				inpFileCount += 1 # Увеличиваем счётчик найденных файлов

		inpFileLine += 1 # Увеличиваем номер обрабатываемой строки

# Обработали все файлы

# Если указано меньше трёх файлов игры, выходим с ошибкой
if inpFileCount < 3:
	print ("ERROR! Not enough files")
	sys.exit(1)

# Если превышено количество файлов 18 (с учётом загрузчика)
if inpFileCount > maxFiles+1:
	print ("ERROR! Maximum number of files exceeded")
	sys.exit(1)

outFileMassive[outFileCatAddr] = 0xFF # В конец таблицы файлов добавляем маркер её окончания

outFile.write (outFileMassive) # Пишем в выходной файл сформированный массив данных
outFileLen = len (outFileMassive)
outFile.close() # Закрываем выходной файл


# Вывод финальной информации о выходном файле
print ("\nOutput File: " + args[outputFilePos]) # Имя выходного файла

# Длина сформированного файла с прошивкой
print ("Length = ", end='')
print (decToHex (outFileLen, 6), end='') # Конвертация числа в удобный hex вид #xxxxxxx
print (' (dec ', end='')
print (outFileLen, end='')
print (') bytes')

# Контрольная сумма выходного файла
print ("Checksum = ", end='')
print (decToHex (checkSum(outFileMassive),4)) # Конвертация числа в удобный hex вид #xxxxxxx
print ("COMPLETED")

sys.exit(0)